/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.Out;
import java.awt.TextArea;
import java.io.PrintWriter;

public final class StdOutWriter
extends PrintWriter {
    private TextArea text;
    private int col;
    private static final int wrap = 78;

    public StdOutWriter() {
        super(System.out, true);
    }

    public void setGUIMode(TextArea textArea) {
        this.text = textArea;
    }

    public void write(int n) {
        if (this.text != null) {
            this.text.append(String.valueOf((char)n));
            if (++this.col > 78) {
                this.println();
            }
        } else {
            super.write(n);
        }
    }

    public void write(char[] cArray, int n, int n2) {
        if (this.text != null) {
            this.text.append(new String(cArray, n, n2));
            if ((this.col += n2) > 78) {
                this.println();
            }
        } else {
            super.write(cArray, n, n2);
        }
    }

    public void write(String string, int n, int n2) {
        if (this.text != null) {
            this.text.append(string.substring(n, n + n2));
            if ((this.col += n2) > 78) {
                this.println();
            }
        } else {
            super.write(string, n, n2);
            this.flush();
        }
    }

    public void println() {
        if (this.text != null) {
            this.text.append(Out.NL);
            this.col = 0;
        } else {
            super.println();
        }
    }
}

